<?php

namespace App\Service;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class DataProcessor
{
    private $headers = [];
    private $data = [];

    public function processFile(string $filePath): void
    {
        $fileType = IOFactory::identify($filePath);
        $reader = IOFactory::createReader($fileType);
        $spreadsheet = $reader->load($filePath);

        // Assuming the data is in the first sheet
        $sheet = $spreadsheet->getActiveSheet();
        $this->data = $sheet->toArray();

        // Extract headers
        $this->headers = array_shift($this->data);
    }

    public function getChartOptions(): array
    {
        return [
            'x' => $this->headers,
            'y' => $this->headers
        ];
    }

    public function extractData(string $xAxis, string $yAxis): array
    {
        $xIndex = array_search($xAxis, $this->headers);
        $yIndex = array_search($yAxis, $this->headers);

        if ($xIndex === false || $yIndex === false) {
            throw new \Exception("Invalid x or y axis provided");
        }

        $result = [];
        foreach ($this->data as $row) {
            if (isset($row[$xIndex]) && isset($row[$yIndex])) {
                $result[] = [
                    'x' => $row[$xIndex],
                    'y' => $row[$yIndex]
                ];
            }
        }

        return $result;
    }
}
