<?php

namespace App\Form;

use App\Entity\EmployeeDepartment;
use App\Entity\EmployeeDivision;
use App\Entity\User;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Regex;

class UserType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email', EmailType::class, [
                'label' => false
            ])
            ->add('password', PasswordType::class, [
                'label' => false,
                'always_empty' => false,
                'constraints' => [
                    new Regex([
                        'pattern' => '/^(?=.*[a-z])(?=.*\d).{8,}$/',
                        'message' => 'Password must be at least 8 characters long and contain at least one uppercase letter and one digit.'
                    ])
                ]
            ])
            ->add('FirstName', TextType::class, [
                'label' => false
            ])
            ->add('LastName', TextType::class, [
                'label' => false
            ])
            ->add('Verified', CheckboxType::class, [
                'label' => false
            ])
            ->add('roles', ChoiceType::class, [
                'label' => false,
                'choices' => [
                    'Developer' => 'ROLE_DEVELOPER',
                    'Designer' => 'ROLE_DESIGNER',
                    'Manager' => 'ROLE_MANAGER',
                    'Analyst' => 'ROLE_ANALYST',
                    'Administrator' => 'ROLE_ADMINISTRATOR'
                ],
                'placeholder' => 'Select Role',
                'expanded' => false,
                'multiple' => true
            ])
            ->add('Department', EntityType::class, [
                'placeholder'=>'Select Department',
                'class' => EmployeeDepartment::class,
                'choice_label' => 'EmployeeDepartmentID',
                'label' => false
            ])

            ->add('Division', EntityType::class, [
                'placeholder'=>'Select Division',
                'class' => EmployeeDivision::class,
                'choice_label' => 'EmployeeDivisionID',
                'label' => false
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }
}
