<?php

namespace App\Form;

use App\Entity\County;
use App\Entity\Post;
use phpDocumentor\Reflection\Types\Collection;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\LiveComponent\Form\Type\LiveCollectionType;
use Vich\UploaderBundle\Form\Type\VichFileType;

class PostType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('title', null,
                [
                    'label' => 'Title',
                    'attr' => ['class' => 'form-control input-default'],

                ])
            ->add('subtitle',null, [
                'label' => 'Subtitle',
                'attr' => ['class' => 'form-control input-default'],

            ])
            ->add('Content', null,[
                'label' => 'Content',
                'attr' => ['class' => ' content-ck'],

            ])
            ->add('ContentSummary', null, [
                'label' => 'Content Summary',
                'attr' => ['class' => 'form-control input-default'],

            ])
            ->add('tags', null,[
                'label' => 'tags',
                'attr' => ['class' => 'form-control input-default'],

            ])
            ->add('published', CheckboxType::class,[
                'label' => 'IS Published?',
                'attr' => ['class' => 'form-control input-default', 'checked'=>true],
            ])
            ->add('publishAt', DateTimeType::class,[
                'label' => 'You can schedule this post. leave blank to publish immediately',
                'attr' => ['class' => 'form-control input-default'],
                'widget'=>'single_text',
                'required'=>false,
                'html5'=>true

            ])
            ->add('MainImageFile',  VichFileType::class,
                [
                    'label' => '',
                    'required' => false,
                    'attr' =>['class' => 'form-control input-default'],
                    'allow_delete' => true,
                    'delete_label' => 'delete previous picture',
                    'asset_helper' => true,
                    'download_uri'=>false,
                    'error_bubbling'=>true,
                ])
           /* ->add('hitCount')*/
          /*  ->add('createdAt')*/
            /*   ->add('UpdatedAt')*/
            ->add('InvolvedCounties', EntityType::class, [
                'class' => County::class,
                'choice_label' => 'Name',
                'multiple' => true,
                'expanded'=>true
            ])

            ->add('data',LiveCollectionType::class,[
                'entry_type' => PostDataType::class,
                'entry_options' => ['label' => false],
                'label' => false,
                'allow_add' => true,
                'allow_delete' => true,
                'by_reference' => false,
                'attr'=>['data-model' => 'norender|*']
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Post::class,
        ]);
    }
}
