<?php

namespace App\Entity;

use App\Repository\PostRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\HttpFoundation\File\File;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

#[ORM\Entity(repositoryClass: PostRepository::class)]
#[Vich\Uploadable]
class Post
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $title = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $subtitle = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $Content = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $ContentSummary = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $tags = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $MainImage = null;

    #[Vich\UploadableField(mapping: 'stats_ke_post', fileNameProperty: 'MainImage')]
    private ?File $MainImageFile = null;

    #[ORM\Column(nullable: true)]
    private ?int $hitCount = null;

    #[ORM\ManyToMany(targetEntity: County::class, inversedBy: 'posts')]
    private Collection $InvolvedCounties;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $UpdatedAt = null;

    /**
     * @var Collection<int, PostData>
     */
    #[ORM\OneToMany(targetEntity: PostData::class, mappedBy: 'post',cascade: ['persist'], orphanRemoval: true)]
    private Collection $data;

    #[ORM\Column(nullable: true)]
    private ?bool $IsPublished = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $PublishAt = null;


    public function __construct()
    {
        $this->InvolvedCounties = new ArrayCollection();
        $this->data = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): static
    {
        $this->title = $title;

        return $this;
    }

    public function getSubtitle(): ?string
    {
        return $this->subtitle;
    }

    public function setSubtitle(?string $subtitle): static
    {
        $this->subtitle = $subtitle;

        return $this;
    }

    public function getContent(): ?string
    {
        return $this->Content;
    }

    public function setContent(?string $Content): static
    {
        $this->Content = $Content;

        return $this;
    }

    public function getContentSummary(): ?string
    {
        return $this->ContentSummary;
    }

    public function setContentSummary(?string $ContentSummary): static
    {
        $this->ContentSummary = $ContentSummary;

        return $this;
    }

    public function getTags(): ?string
    {
        return $this->tags;
    }

    public function setTags(?string $tags): static
    {
        $this->tags = $tags;

        return $this;
    }

    public function getMainImage(): ?string
    {
        return $this->MainImage;
    }

    public function setMainImage(?string $MainImage): static
    {
        $this->MainImage = $MainImage;

        return $this;
    }

    public function getHitCount(): ?int
    {
        return $this->hitCount;
    }

    public function setHitCount(?int $hitCount): static
    {
        $this->hitCount = $hitCount;

        return $this;
    }

    /**
     * @return Collection<int, County>
     */
    public function getInvolvedCounties(): Collection
    {
        return $this->InvolvedCounties;
    }

    public function addInvolvedCounty(County $involvedCounty): static
    {
        if (!$this->InvolvedCounties->contains($involvedCounty)) {
            $this->InvolvedCounties->add($involvedCounty);
        }

        return $this;
    }

    public function removeInvolvedCounty(County $involvedCounty): static
    {
        $this->InvolvedCounties->removeElement($involvedCounty);

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): static
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->UpdatedAt;
    }

    public function setUpdatedAt(?\DateTimeImmutable $UpdatedAt): static
    {
        $this->UpdatedAt = $UpdatedAt;

        return $this;
    }

    public function getMainImageFile(): ?File
    {
        return $this->MainImageFile;
    }

    public function setMainImageFile(?File $MainImageFile): void
    {
        $this->MainImageFile = $MainImageFile;
        if (null !== $MainImageFile) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->UpdatedAt = new \DateTimeImmutable();
        }
    }

    /**
     * @return Collection<int, PostData>
     */
    public function getData(): Collection
    {
        return $this->data;
    }

    public function addData(PostData $data): static
    {
        if (!$this->data->contains($data)) {
            $this->data->add($data);
            $data->setPost($this);
        }

        return $this;
    }

    public function removeData(PostData $data): static
    {
        if ($this->data->removeElement($data)) {
            // set the owning side to null (unless already changed)
            if ($data->getPost() === $this) {
                $data->setPost(null);
            }
        }

        return $this;
    }

    public function isPublished(): ?bool
    {
        return $this->IsPublished;
    }

    public function setPublished(?bool $IsPublished): static
    {
        $this->IsPublished = $IsPublished;

        return $this;
    }

    public function getPublishAt(): ?\DateTimeImmutable
    {
        return $this->PublishAt;
    }

    public function setPublishAt(?\DateTimeImmutable $PublishAt): static
    {
        $this->PublishAt = $PublishAt;

        return $this;
    }

}
