<?php

namespace App\Entity;

use App\Repository\MinistryRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MinistryRepository::class)]
class Ministry extends BaseEntity
{

    #[ORM\Column(length: 255)]
    private ?string $MinistryID = null;

    /**
     * @var Collection<int, MinistryDepartment>
     */
    #[ORM\OneToMany(targetEntity: MinistryDepartment::class, mappedBy: 'ministry')]
    private Collection $departments;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $PrimeCabinetSecretary = null;

    public function __construct()
    {
        $this->departments = new ArrayCollection();
    }


    public function getMinistryID(): ?string
    {
        return $this->MinistryID;
    }

    public function setMinistryID(string $MinistryID): static
    {
        $this->MinistryID = $MinistryID;

        return $this;
    }

    /**
     * @return Collection<int, MinistryDepartment>
     */
    public function getDepartments(): Collection
    {
        return $this->departments;
    }

    public function addDepartment(MinistryDepartment $department): static
    {
        if (!$this->departments->contains($department)) {
            $this->departments->add($department);
            $department->setMinistry($this);
        }

        return $this;
    }

    public function removeDepartment(MinistryDepartment $department): static
    {
        if ($this->departments->removeElement($department)) {
            // set the owning side to null (unless already changed)
            if ($department->getMinistry() === $this) {
                $department->setMinistry(null);
            }
        }

        return $this;
    }

    public function getPrimeCabinetSecretary(): ?string
    {
        return $this->PrimeCabinetSecretary;
    }

    public function setPrimeCabinetSecretary(?string $PrimeCabinetSecretary): static
    {
        $this->PrimeCabinetSecretary = $PrimeCabinetSecretary;

        return $this;
    }
}
