<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use App\Entity\Common\FullyAuditedEntity;
use App\Repository\EmployeeDivisionRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EmployeeDivisionRepository::class)]
#[ORM\Table(name: 'EmployeeDivision')]
#[ApiResource]
class EmployeeDivision extends  BaseEntity
{

    #[ORM\Column(length: 72, unique: true)]
    private ?string $EmployeeDivisionID = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $EmployeeDivisionDescription = null;

    /**
     * @var Collection<int, User>
     */
    #[ORM\OneToMany(targetEntity: User::class, mappedBy: 'Division')]
    private Collection $employee;

    public function __construct()
    {
        $this->employee = new ArrayCollection();
    }

    public function getEmployeeDivisionID(): ?string
    {
        return $this->EmployeeDivisionID;
    }

    public function setEmployeeDivisionID(string $EmployeeDivisionID): static
    {
        $this->EmployeeDivisionID = $EmployeeDivisionID;

        return $this;
    }

    public function getEmployeeDivisionDescription(): ?string
    {
        return $this->EmployeeDivisionDescription;
    }

    public function setEmployeeDivisionDescription(?string $EmployeeDivisionDescription): static
    {
        $this->EmployeeDivisionDescription = $EmployeeDivisionDescription;

        return $this;
    }

    /**
     * @return Collection<int, User>
     */
    public function getEmployee(): Collection
    {
        return $this->employee;
    }

    public function addEmployee(User $employee): static
    {
        if (!$this->employee->contains($employee)) {
            $this->employee->add($employee);
        }

        return $this;
    }

    public function removeEmployee(User $employee): static
    {
        if ($this->employee->removeElement($employee)) {
            // set the owning side to null (unless already changed)
            if ($employee->getDivision() === $this) {
                $employee->setDivision(null);
            }
        }

        return $this;
    }
}
