<?php

namespace App\Controller;

use App\Entity\Post;
use App\Form\PostType;
use App\Repository\PostRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\UX\Chartjs\Builder\ChartBuilderInterface;
use Symfony\UX\Chartjs\Model\Chart;

#[Route(path: AppConst::APP_ADMIN_ROUTE_PREFIX . '/post')]
class PostController extends AbstractController
{
    #[Route('/', name: 'app_post_index', methods: ['GET'])]
    public function index(PostRepository $postRepository): Response
    {
        return $this->render('post/index.html.twig', [
            'posts' => $postRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'List Posts','current' => 'Post']
        ]);
    }
    #[Route('/dashboard', name: 'app_post_dashboard', methods: ['GET'])]
    public function overview(PostRepository $postRepository): Response
    {
        return $this->render('post/overview.html.twig', [
            'posts' => $postRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Post Dashboard','current' => 'Overview']

        ]);
    }

    #[Route('/new', name: 'app_post_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $post = new Post();
        $form = $this->createForm(PostType::class, $post);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $post->setCreatedAt(new \DateTimeImmutable());
            $entityManager->persist($post);
            $entityManager->flush();

            return $this->redirectToRoute('app_post_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('post/new.html.twig', [
            'post' => $post,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Create New Stat Post',
            'toolbar' =>['title' =>'New Post','current' => 'Add Post']
        ]);
    }

    #[Route('/demo_new', name: 'app_post_demo_new', methods: ['GET', 'POST'])]
    public function demo_new(Request $request, EntityManagerInterface $entityManager, ChartBuilderInterface $chartBuilder): Response
    {
        $post = new Post();
        $form = $this->createForm(PostType::class, $post);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $post->setCreatedAt(new \DateTimeImmutable());
            $post->setUpdatedAt(new \DateTimeImmutable());
            //dd($post);

            $entityManager->persist($post);
            $entityManager->flush();
            return $this->redirectToRoute('app_post_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('post/demo_new.html.twig', [
            'post' => $post,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Create New Stat Post',
            'toolbar' =>['title' =>'New Post','current' => 'Add Post'

            ]
        ]);
    }

    #[Route('/{id}', name: 'app_post_show', methods: ['GET'])]
    public function show(Post $post): Response
    {
        return $this->render('post/show.html.twig', [
            'post' => $post,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_post_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Post $post, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(PostType::class, $post);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_post_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('post/edit.html.twig', [
            'post' => $post,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Edit Stats Post'
        ]);
    }

    #[Route('/{id}', name: 'app_post_delete', methods: ['POST'])]
    public function delete(Request $request, Post $post, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$post->getId(), $request->request->get('_token'))) {
            $entityManager->remove($post);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_post_index', [], Response::HTTP_SEE_OTHER);
    }
}
