<?php

namespace App\Controller;

use App\Entity\Ministry;
use App\Form\MinistryType;
use App\Repository\MinistryRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(AppConst::APP_ADMIN_ROUTE_PREFIX.'/ministry')]
class MinistryController extends AbstractController
{
    #[Route('/', name: 'app_ministry_index', methods: ['GET'])]
    public function index(MinistryRepository $ministryRepository): Response
    {
        return $this->render('ministry/index.html.twig', [
            'ministries' => $ministryRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministries','current' => 'Ministries']
        ]);
    }

    #[Route('/new', name: 'app_ministry_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $ministry = new Ministry();
        $form = $this->createForm(MinistryType::class, $ministry);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($ministry);
            $entityManager->flush();

            return $this->redirectToRoute('app_ministry_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ministry/new.html.twig', [
            'ministry' => $ministry,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministries','current' => 'Add ministry']
        ]);
    }

    #[Route('/{id}', name: 'app_ministry_show', methods: ['GET'])]
    public function show(Ministry $ministry): Response
    {
        return $this->render('ministry/show.html.twig', [
            'ministry' => $ministry,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_ministry_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Ministry $ministry, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(MinistryType::class, $ministry);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_ministry_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('ministry/edit.html.twig', [
            'ministry' => $ministry,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Ministries','current' => 'Edit ministry']
        ]);
    }

    #[Route('/{id}', name: 'app_ministry_delete', methods: ['POST'])]
    public function delete(Request $request, Ministry $ministry, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$ministry->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($ministry);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_ministry_index', [], Response::HTTP_SEE_OTHER);
    }
}
