<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class MenuController extends AbstractController
{

    #[Route('/activateMenu', name:'active_menu', methods: ['POST'])]
    public function activateMenu(Request $request): Response
    {
        $jsonData = json_decode($request->getContent(), true);
        $activeMenuId = $jsonData['menu_id'];
        //dd($activeMenuId);
        // Set active menu in session
        $request->getSession()->set('active_menu', $activeMenuId);

        // Return a JSON response with success message
        return $this->json(['message' => 'Menu activated successfully', 'active_menu' => $activeMenuId]);
    }
}
