<?php

namespace App\Controller;

use App\Entity\User;
use App\Form\UserType;
use App\Repository\UserRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(AppConst::APP_ADMIN_ROUTE_PREFIX.'/users')]
class EmployeeController extends AbstractController
{
    #[Route('/', name: 'app_employee_index', methods: ['GET'])]
    public function index(UserRepository $usersRepository, Request $request): Response
    {
        $user = new User();
        $form = $this->createForm(UserType::class, $user);
        $form->handleRequest($request);

        return $this->render('human_resource/employee/index.html.twig', [
            'user' => $user,
            'form' => $form,
            'users' => $usersRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Users','current' => 'User List']
        ]);
    }

    #[Route('/new', name: 'app_employee_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {

        /*if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($user);
            $entityManager->flush();

            return $this->redirectToRoute('app_employee_index', [], Response::HTTP_SEE_OTHER);
        }*/

        return $this->render('human_resource/employee/new.html.twig', [

        ]);
    }

    /*#[Route('/{id}', name: 'app_employee_show', methods: ['GET'])]
    public function show(User $user): Response
    {
        return $this->render('employee/show.html.twig', [
            'user' => $user,
        ]);
    }*/

    #[Route('/{id}/edit', name: 'app_employee_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, User $user, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(UserType::class, $user);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_employee_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('human_resource/employee/edit.html.twig', [
            'user' => $user,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Stats Post',
            'toolbar' =>['title' =>'Edit Users','current' => 'Edit user']
        ]);
    }

    #[Route('/{id}', name: 'app_employee_delete', methods: ['POST'])]
    public function delete(Request $request, User $user, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$user->getId(), $request->getPayload()->get('_token'))) {
            $entityManager->remove($user);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_employee_index', [], Response::HTTP_SEE_OTHER);
    }
}
