<?php

namespace App\Controller;

use App\Entity\County;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class CountyInformationController extends AbstractController
{
    #[Route('/county/information/{id}', name: 'app_county_information')]
    public function index(County $county, PaginatorInterface $paginator, Request $request): Response
    {
        $allCountyPosts = $county->getPosts();
       $posts =  $paginator->paginate(
            $allCountyPosts,
            $request->query->getInt('page', 1),
            12

        );
        return $this->render('county_information/index.html.twig', [
           AppConst::APP_LAYOUT => AppConst::USER_LAYOUT,
           'county' => $county,
           'posts' => $posts
        ]);
    }
}
