<?php

namespace App\Controller;

use App\Entity\County;
use App\Form\CountyType;
use App\Repository\CountyRepository;
use App\Shared\AppConst;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\SerializerInterface;

#[Route('/county')]
class CountyController extends AbstractController
{
    #[Route('/', name: 'app_county_index', methods: ['GET'])]
    public function index(CountyRepository $countyRepository): Response
    {
        return $this->render('county/index.html.twig', [
            'counties' => $countyRepository->findAll(),
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Counties'
        ]);
    }

    #[Route('/new', name: 'app_county_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $county = new County();
        $form = $this->createForm(CountyType::class, $county);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($county);
            $entityManager->flush();

            return $this->redirectToRoute('app_county_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('county/new.html.twig', [
            'county' => $county,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Create New County'
        ]);
    }

    #[Route('/{id}', name: 'app_county_show', methods: ['GET'])]
    public function show(County $county): Response
    {
        return $this->render('county/show.html.twig', [
            'county' => $county,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Show County'
        ]);
    }

    #[Route('/{id}/edit', name: 'app_county_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, County $county, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(CountyType::class, $county);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_county_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('county/edit.html.twig', [
            'county' => $county,
            'form' => $form,
            AppConst::APP_LAYOUT =>AppConst::ADMIN_LAYOUT,
            AppConst::ADMIN_LAYOUT_TITLE => 'Edit County'
        ]);
    }

    #[Route('/{id}', name: 'app_county_delete', methods: ['POST'])]
    public function delete(Request $request, County $county, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$county->getId(), $request->request->get('_token'))) {
            $entityManager->remove($county);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_county_index', [], Response::HTTP_SEE_OTHER);
    }


    #[Route('/api/get-counties', name: 'app_api_get_counties', methods: ['GET'])]
    public  function getCounties(CountyRepository $countyRepository, SerializerInterface $serializer): JsonResponse
    {
        $countiesResults = $countyRepository->findAll();

        $counties = [];
        foreach ($countiesResults as $county)
        {
           $countyDto = new \App\Entity\Dto\County();
           $countyDto->id = $county->getId();
           $countyDto->Name = $county->getName();
           $countyDto->Capital = $county->getCapital();
            $counties[] = $countyDto;
        }


        $jsonData = $serializer->serialize($counties, 'json');





        return new JsonResponse($jsonData);
    }
}
