<?php

namespace App\Controller;

use App\Entity\Post;
use App\Repository\PostRepository;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class AtStatsKenyaPostController extends AbstractController
{
    #[Route('/at-stats-kenya/post/{id}', name: 'app_at_stats_kenya_post')]
    public function index(Post $post): Response
    {
        return $this->render('at_stats_kenya_post/index.html.twig', [
            'controller_name' => 'AtStatsKenyaPostController',
            'post' => $post
        ]);
    }

    #[Route('/at-stats-kenya/explore', name: 'app_at_stats_kenya_explore')]
    public function explore(PostRepository $postRepository, PaginatorInterface $paginator, Request $request): Response
    {
        $allPosts = $postRepository->findAll();
        $posts = $paginator->paginate(
            $allPosts,
            $request->query->getInt('page', 1),
            12

        );
        return $this->render('at_stats_kenya_post/explore.html.twig', [
            'controller_name' => 'AtStatsKenyaPostController',
            'posts' => $posts,
            'posts.count' => count($allPosts)
        ]);
    }
}
