<?php

namespace App\Component;

use App\Repository\UserRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveListener;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('UsersList')]
class UsersList extends AbstractController

{
    use DefaultActionTrait;
    use ComponentToolsTrait;

    #[LiveProp(writable: true)]
    public ?string $query = null;

    #[LiveProp(writable: true)]
    public bool $hasSuccess = false;
    #[LiveProp]
    public string $feedback = '';
    private UserRepository $usersRepository;

    public function __construct( UserRepository $usersRepository)
    {
        $this->usersRepository = $usersRepository;
    }

    #[LiveAction]
    public function cancelAlert(): void
    {
        $this->hasSuccess = false;
    }

    #[LiveListener('userAdded')]
    public function refreshList(): void
    {
        $this->feedback = 'User added successfully';
        $this->hasSuccess = true;
        $this->getUsers();
    }

    #[LiveAction]
    public function getUsers()
    {
        return $this->usersRepository->searchUsers($this->query);
    }

    #[LiveAction]
    public function editable(#[LiveArg] int $id): void
    {
        $this->redirectToRoute('app_employee_edit', ['id' => $id]);
    }

}