<?php

namespace App\Component;

use App\Entity\NewsLetterSubscriptions;
use App\Form\NewsLetterSubscriptionsType;
use App\Form\UserType;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\FormInterface;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\ComponentToolsTrait;
use Symfony\UX\LiveComponent\ComponentWithFormTrait;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent('NewsLetter')]
class NewsLetter extends AbstractController
{
    use ComponentWithFormTrait;
    use DefaultActionTrait;
    use ComponentToolsTrait;

    #[LiveProp(writable: true)]
    public ?NewsLetterSubscriptions $subscription = null;

    #[LiveProp(writable: true)]
    public bool $success= false;

    protected function instantiateForm(): FormInterface
    {
        return $this->createForm(NewsLetterSubscriptionsType::class, $this->subscription);

    }

    private function getDataModelValue(): ?string
    {
        return 'norender|*';
    }

    #[LiveAction]
    public function save( EntityManagerInterface      $entityManager,): void
    {
        $this->submitForm();

        /** @var NewsLetterSubscriptions $newsLetterSubscriber */
        $newsLetterSubscriber = $this->getForm()->getData();
        $newsLetterSubscriber->setCreatedAt(new \DateTimeImmutable());
        $newsLetterSubscriber->setCreatedBy('client initiated:');

        $entityManager->persist($newsLetterSubscriber);
        $entityManager->flush();

        $this->success = true;
    }
}
