import { Controller } from '@hotwired/stimulus';

export default class extends Controller {
    async activate( event) {
        event.preventDefault();
        const menu_id = event.params.menuId;

        const link = event.target.parentNode

        console.log()

        // Add 'active' class to the clicked menu item
        event.target.classList.add('active');

        // Send AJAX request to update session
        fetch('/activateMenu', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
            body: JSON.stringify({ menu_id: menu_id }),
        })
            .then(response => response.json())
            .then(data => {
                //console.log(data);
                // Redirect to href after setting the active menu
                 window.location.href = event.target.parentNode.href;
            })
            .catch(error => console.error('Error:', error));
       // window.location.href = event.target.parentNode.href;
    }
}
